/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jtbcore.model.BaseStringMap;
import jtbcore.service.ServiceBase;

public class MetaService
extends ServiceBase {
    public void setMeta(String name, String key, String data) throws SQLException, IOException {
        List<BaseStringMap> l = this.connection.queryBsmList("select object_meta_id from base__object_meta where object_name = ?  and object_key = ?", name, key);
        BaseStringMap bsm = new BaseStringMap();
        bsm.setProperty("object_name", name);
        bsm.setProperty("object_key", key);
        bsm.setProperty("object_value", data);
        if (l.size() > 0) {
            bsm.setProperty("object_meta_id", l.get(0).getProperty("object_meta_id"));
        }
        this.connection.save("base__object_meta", "object_meta_id", bsm);
        if (l.size() > 1) {
            int x = 1;
            while (x < l.size()) {
                this.connection.query("delete from base__object_meta where object_meta_id = ?", l.get(x).getPropertyInt("object_meta_id"));
                ++x;
            }
        }
    }

    public void setMeta(String name, Integer objectId, String key, String data) throws SQLException, IOException {
        List<BaseStringMap> l = this.connection.queryBsmList("select object_meta_id from base__object_meta where object_name = ? and object_id = ? and object_key = ?", name, objectId, key);
        BaseStringMap bsm = new BaseStringMap();
        bsm.setProperty("object_name", name);
        bsm.setProperty("object_id", objectId);
        bsm.setProperty("object_key", key);
        bsm.setProperty("object_value", data);
        if (l.size() > 0) {
            bsm.setProperty("object_meta_id", l.get(0).getProperty("object_meta_id"));
        }
        this.connection.save("base__object_meta", "object_meta_id", bsm);
        if (l.size() > 1) {
            int x = 1;
            while (x < l.size()) {
                this.connection.query("delete from base__object_meta where object_meta_id = ?", l.get(x).getPropertyInt("object_meta_id"));
                ++x;
            }
        }
    }

    public String getMetaNameKey(String name, String key) throws SQLException {
        BaseStringMap m = this.connection.queryBsm("select object_value from base__object_meta where object_name = ? and object_key = ? ", name, key);
        if (m == null) {
            return null;
        }
        return m.getProperty("object_value");
    }

    public String getMetaByKey(String name, Integer id, String key) throws SQLException {
        return this.getMetaByKey(name, id, key, null);
    }

    public String getMetaByKey(String name, Integer id, String key, String defaultValue) throws SQLException {
        BaseStringMap m = this.connection.queryBsm("select object_value from base__object_meta where object_key = ? and object_id = ? and object_name = ?", key, id, name);
        if (m == null) {
            return defaultValue;
        }
        return m.getProperty("object_value");
    }

    public Integer addMeta(String key, Integer id, String name, String value) throws SQLException, IOException {
        BaseStringMap bsm = new BaseStringMap();
        bsm.setProperty("object_key", key);
        bsm.setProperty("object_id", id);
        bsm.setProperty("object_name", name);
        bsm.setProperty("object_value", value);
        return this.connection.save("base__object_meta", "object_meta_id", bsm);
    }

    public List<BaseStringMap> listMeta(String key, Integer id, String name) throws SQLException, IOException {
        List<BaseStringMap> l = this.connection.queryBsmList("select * from base__object_meta where object_key = ? and object_id = ? object_name = ?", key, id, name);
        return l;
    }

    public List<String> listMetaValues(String key, Integer id, String name) throws SQLException, IOException {
        List<BaseStringMap> recs = this.listMeta(key, id, name);
        ArrayList<String> values = new ArrayList<String>();
        for (BaseStringMap rec : recs) {
            values.add(rec.getProperty("object_value"));
        }
        return values;
    }
}

